/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ElytraAutoFly
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Double> targetHeight;
    private final Setting<Integer> targetX;
    private final Setting<Integer> targetZ;
    private final Setting<String> webhookUrl;
    private final class_310 mc;
    private Stage stage;
    private boolean elytraStarted;
    private long lastFireworkTime;
    private long lookUpUntil;
    private double lastAltitude;
    private boolean lowDurabilityLanding;

    public ElytraAutoFly() {
        super(CatalystAddon.CATEGORY, "ElytraAutoFly", "Auto Elytra flight with airplane-style landing.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.targetHeight = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("target-height")).description("Y height to ascend to.")).defaultValue(150.0).min(64.0).sliderMax(300.0).build());
        this.targetX = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-x")).description("X coordinate to fly to.")).defaultValue((Object)0)).build());
        this.targetZ = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-z")).description("Z coordinate to fly to.")).defaultValue((Object)0)).build());
        this.webhookUrl = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL.")).defaultValue((Object)"")).build());
        this.mc = class_310.method_1551();
        this.stage = Stage.INIT;
        this.elytraStarted = false;
        this.lastFireworkTime = 0L;
        this.lookUpUntil = 0L;
        this.lastAltitude = 0.0;
        this.lowDurabilityLanding = false;
    }

    public void onActivate() {
        this.stage = Stage.INIT;
        this.elytraStarted = false;
        this.lookUpUntil = 0L;
        this.lowDurabilityLanding = false;
    }

    public void onDeactivate() {
        this.mc.field_1690.field_1894.method_23481(false);
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        class_746 p = this.mc.field_1724;
        switch (this.stage.ordinal()) {
            case 0: {
                for (int i = 0; i < 36; ++i) {
                    class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
                    if (stack.method_7909() != class_1802.field_8833) continue;
                    this.mc.field_1761.method_2906(this.mc.field_1724.field_7512.field_7763, 6, i, class_1713.field_7791, (class_1657)this.mc.field_1724);
                    break;
                }
                this.stage = Stage.ASCENDING;
                break;
            }
            case 1: {
                if (this.isElytraLowDurability()) {
                    this.emergencyLand();
                    return;
                }
                if (p.method_24828()) {
                    p.method_6043();
                    return;
                }
                if (!this.elytraStarted) {
                    this.mc.field_1724.field_3944.method_52787((class_2596)new class_2848((class_1297)this.mc.field_1724, class_2848.class_2849.field_12982));
                    this.elytraStarted = true;
                    this.mc.field_1724.method_36457(-45.0f);
                    this.useFirework();
                    this.lastFireworkTime = this.mc.field_1687.method_8510();
                    this.lookUpUntil = this.mc.field_1687.method_8510() + 60L;
                }
                if (this.mc.field_1687.method_8510() - this.lastFireworkTime > 60L) {
                    this.mc.field_1724.method_36457(-45.0f);
                    this.useFirework();
                    this.lastFireworkTime = this.mc.field_1687.method_8510();
                    this.lookUpUntil = this.mc.field_1687.method_8510() + 60L;
                }
                if (!(p.method_23318() >= (Double)this.targetHeight.get())) break;
                this.stage = Stage.CRUISING;
                this.lastAltitude = p.method_23318();
                ChatUtils.info((String)"Reached height. Cruising...", (Object[])new Object[0]);
                break;
            }
            case 2: {
                double currentY;
                if (this.isElytraLowDurability()) {
                    this.emergencyLand();
                    return;
                }
                double dx = (double)((Integer)this.targetX.get()).intValue() - p.method_23317();
                double dz = (double)((Integer)this.targetZ.get()).intValue() - p.method_23321();
                double distance = Math.sqrt(dx * dx + dz * dz);
                if (this.mc.field_1687.method_8510() < this.lookUpUntil) {
                    this.mc.field_1724.method_36457(-45.0f);
                } else {
                    float desiredYaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
                    float yaw = this.mc.field_1724.method_36454();
                    this.mc.field_1724.method_36456(yaw + (desiredYaw - yaw) * 0.1f);
                    this.mc.field_1724.method_36457(0.0f);
                }
                if (distance > 10.0) {
                    this.mc.field_1690.field_1894.method_23481(true);
                } else {
                    this.mc.field_1690.field_1894.method_23481(false);
                    this.stage = Stage.DESCENDING;
                }
                if (this.mc.field_1687.method_8510() % 100L == 0L && (currentY = p.method_23318()) < (Double)this.targetHeight.get() + 5.0) {
                    this.mc.field_1724.method_36457(-45.0f);
                    this.useFirework();
                    this.lastFireworkTime = this.mc.field_1687.method_8510();
                    this.lookUpUntil = this.mc.field_1687.method_8510() + 60L;
                    this.lastAltitude = currentY;
                }
                if (!(this.lastAltitude - p.method_23318() > 10.0)) break;
                this.mc.field_1724.method_36457(-45.0f);
                this.useFirework();
                this.lastFireworkTime = this.mc.field_1687.method_8510();
                this.lookUpUntil = this.mc.field_1687.method_8510() + 60L;
                this.lastAltitude = p.method_23318();
                break;
            }
            case 3: {
                double dz;
                int chunkX = (Integer)this.targetX.get() >> 4;
                int chunkZ = (Integer)this.targetZ.get() >> 4;
                if (!this.mc.field_1687.method_8393(chunkX, chunkZ)) {
                    this.mc.field_1690.field_1894.method_23481(false);
                    this.mc.field_1724.method_36457(-10.0f);
                    return;
                }
                double dx = (double)((Integer)this.targetX.get()).intValue() - p.method_23317();
                double distance = Math.sqrt(dx * dx + (dz = (double)((Integer)this.targetZ.get()).intValue() - p.method_23321()) * dz);
                if (distance > 2.0) {
                    float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
                    this.mc.field_1724.method_36456(yaw);
                    this.mc.field_1724.method_36457(-15.0f);
                    this.mc.field_1690.field_1894.method_23481(true);
                } else {
                    this.mc.field_1690.field_1894.method_23481(false);
                    this.mc.field_1724.method_36457(10.0f);
                }
                if (!p.method_24828()) break;
                this.mc.field_1690.field_1894.method_23481(false);
                if (this.stage == Stage.LANDED) break;
                this.stage = Stage.LANDED;
                String reason = this.lowDurabilityLanding ? "Logged out due to Elytra below 15% durability." : "AutoFly landing complete.";
                this.sendWebhook(reason);
                this.mc.execute(() -> {
                    this.mc.method_1562().method_48296().method_10747((class_2561)class_2561.method_43470((String)reason));
                    this.toggle();
                });
            }
        }
    }

    private void emergencyLand() {
        this.lowDurabilityLanding = true;
        this.stage = Stage.DESCENDING;
        this.sendWebhook("\u26a0\ufe0f Elytra durability below 15%! Emergency landing.");
        ChatUtils.warning((String)"\u26a0\ufe0f Elytra durability below 15%! Emergency landing.", (Object[])new Object[0]);
    }

    private void useFirework() {
        class_1799 firework = this.mc.field_1724.method_5998(class_1268.field_5808);
        if (!(firework.method_7909() instanceof class_1781)) {
            if (!this.equipFirework()) {
                return;
            }
            firework = this.mc.field_1724.method_5998(class_1268.field_5808);
        }
        if (firework.method_7909() instanceof class_1781) {
            this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808);
        }
    }

    private boolean equipFirework() {
        for (int i = 0; i < 36; ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (!(stack.method_7909() instanceof class_1781)) continue;
            int selectedSlot = i < 9 ? i : 0;
            this.mc.field_1724.method_31548().method_61496(selectedSlot);
            if (i >= 9) {
                this.mc.field_1761.method_2906(this.mc.field_1724.field_7512.field_7763, i, selectedSlot, class_1713.field_7791, (class_1657)this.mc.field_1724);
            }
            return true;
        }
        return false;
    }

    private boolean isElytraLowDurability() {
        class_1799 chest = this.mc.field_1724.method_6118(class_1304.field_6174);
        if (chest.method_7909() == class_1802.field_8833 && chest.method_7986()) {
            int damage = chest.method_7919();
            int max = chest.method_7936();
            return (double)(max - damage) / (double)max <= 0.15;
        }
        return false;
    }

    private void sendWebhook(String msg) {
        new Thread(() -> {
            try {
                URL url = new URL((String)this.webhookUrl.get());
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoOutput(true);
                String payload = "{\"content\":\"" + msg + "\"}";
                try (OutputStream os = conn.getOutputStream();){
                    os.write(payload.getBytes(StandardCharsets.UTF_8));
                }
                conn.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
    }

    private static enum Stage {
        INIT,
        ASCENDING,
        CRUISING,
        DESCENDING,
        LANDED;

    }
}

